/****** Object:  Trigger [TRG_RC_CLI_CONSUMIDOR_FINAL]    Script Date: 03/26/2014 07:01:17 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_RC_CLI_CONSUMIDOR_FINAL]'))
DROP TRIGGER [dbo].[TRG_RC_CLI_CONSUMIDOR_FINAL]
GO
GO
GO
GO
--vERSAO 2886
--------------------------------------Tratamento para nao alteracao do consumidor final--------------------------------------
create TRIGGER [dbo].[TRG_RC_CLI_CONSUMIDOR_FINAL] ON [dbo].[RC_CLI] FOR UPDATE AS
	DECLARE @CD_CLI INT
    IF UPDATE (UUID)
	BEGIN
		RETURN;
	END
	SET @CD_CLI = ISNULL((SELECT 
							TOP 1 VALOR 
						   FROM 
								PRC_FILIAL_CONFIG 
							WHERE 
								CD_EMP = 1 
								AND CD_CHAVE = 'CD_CLI_PADRAO'
								AND VALOR IN (SELECT CD_CLI FROM inserted)),0);
	IF @CD_CLI=0 
	begin
		SET @CD_CLI = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = 1 AND CD_CHAVE = 'CD_CLI_PADRAO'),0)
	end

	IF EXISTS (SELECT 
					* 
			   FROM 
					inserted 
				WHERE
					CD_CLI = @CD_CLI)
	  begin
		RAISERROR ('Cliente padrao para o CONSUMIDOR FINAL, alteracao nao permitida.',16, 1);
		ROLLBACK TRANSACTION;
		RETURN;
	  end
